/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.impl.content.registry.util.ImmutableCollectionUtils;
import net.fabricmc.fabric.mixin.content.registry.AxeItemAccessor;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrippableBlockRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrippableBlockRegistry.class);

    private StrippableBlockRegistry() {
    }

    public static void register(class_2248 input, class_2248 stripped) {
        StrippableBlockRegistry.requireNonNullAndAxisProperty(input, "input block");
        StrippableBlockRegistry.requireNonNullAndAxisProperty(stripped, "stripped block");
        class_2248 old = StrippableBlockRegistry.getRegistry().put(input, stripped);
        if (old != null) {
            LOGGER.debug("Replaced old stripping mapping from {} to {} with {}", new Object[]{input, old, stripped});
        }
    }

    private static void requireNonNullAndAxisProperty(class_2248 block, String name) {
        Objects.requireNonNull(block, name + " cannot be null");
        if (!block.method_9595().method_11659().contains(class_2741.field_12496)) {
            throw new IllegalArgumentException(name + " must have the 'axis' property");
        }
    }

    private static Map<class_2248, class_2248> getRegistry() {
        return ImmutableCollectionUtils.getAsMutableMap(AxeItemAccessor::getStrippedBlocks, AxeItemAccessor::setStrippedBlocks);
    }
}

