/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.api.IBetterAdvancementEntryGui;
import betteradvancements.common.api.event.IAdvancementDrawConnectionsEvent;
import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementsScreen;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Resources;
import betteradvancements.common.util.CriterionGrid;
import betteradvancements.common.util.RenderUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_455;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8779;
import net.minecraft.class_8781;

public class BetterAdvancementWidget
implements IBetterAdvancementEntryGui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final BetterAdvancementTab betterAdvancementTabGui;
    private final class_8781 advancementNode;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final class_185 displayInfo;
    private final String title;
    private int width;
    private List<class_5481> description;
    private CriterionGrid criterionGrid;
    private final class_310 minecraft;
    private BetterAdvancementWidget parent;
    private final List<BetterAdvancementWidget> children = Lists.newArrayList();
    private class_167 advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public BetterAdvancementWidget(BetterAdvancementTab betterAdvancementTabGui, class_310 mc, class_8781 advancementNode, class_185 displayInfo) {
        this.betterAdvancementTabGui = betterAdvancementTabGui;
        this.advancementNode = advancementNode;
        this.betterDisplayInfo = betterAdvancementTabGui.getBetterDisplayInfo(this.advancementNode);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = displayInfo.method_811().method_10858(163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : class_3532.method_15375((float)(displayInfo.method_818() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : class_3532.method_15375((float)(displayInfo.method_819() * 27.0f));
        this.refreshHover();
        this.screenScale = mc.method_22683().method_4476(0, false);
    }

    private void refreshHover() {
        class_310 mc = this.minecraft;
        int k = 0;
        if (this.advancementNode.method_53647().comp_1916().method_53664() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancementNode.method_53647().comp_1916().method_53664()).length();
            k = mc.field_1772.method_1727("  ") + mc.field_1772.method_1727("0") * strLengthRequirementCount * 2 + mc.field_1772.method_1727("/");
        }
        int titleWidth = 29 + mc.field_1772.method_1727(this.title) + k;
        BetterAdvancementsScreen screen = this.betterAdvancementTabGui.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancementNode.method_53649(), this.advancementNode.method_53647(), this.advancementProgress, screen.field_22789 / 2, mc.field_1772);
        int maxWidth = !CriterionGrid.requiresShift || class_437.method_25442() ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        this.description = class_2477.method_10517().method_30933(this.findOptimalLines((class_2561)class_2564.method_10889((class_5250)this.displayInfo.method_817().method_27661(), (class_2583)class_2583.field_24360.method_10977(this.displayInfo.method_815().method_830())), maxWidth));
        for (class_5481 line : this.description) {
            maxWidth = Math.max(maxWidth, mc.field_1772.method_30880(line));
        }
        this.width = maxWidth + 8;
    }

    private List<class_5348> findOptimalLines(class_2561 line, int width) {
        if (line.getString().isEmpty()) {
            return Collections.emptyList();
        }
        class_5225 stringsplitter = this.minecraft.field_1772.method_27527();
        List list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        if (list.size() > 1) {
            width = Math.max(width, this.betterAdvancementTabGui.getScreen().internalWidth / 4);
            list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.betterAdvancementTabGui.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        }
        return list;
    }

    private BetterAdvancementWidget getFirstVisibleParent(class_8781 advancement) {
        while ((advancement = advancement.method_53651()) != null && advancement.method_53647().comp_1913().isEmpty()) {
        }
        if (advancement != null && !advancement.method_53647().comp_1913().isEmpty()) {
            return this.betterAdvancementTabGui.getWidget(advancement.method_53649());
        }
        return null;
    }

    public void drawConnectivity(class_332 guiGraphics, int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(guiGraphics, this.parent, scrollX, scrollY, drawInside);
            }
            IAdvancementDrawConnectionsEvent event = Services.PLATFORM.getEventHelper().postAdvancementDrawConnectionsEvent(this.advancementNode);
            for (class_8779 parent : event.getExtraConnections()) {
                BetterAdvancementWidget parentGui = this.betterAdvancementTabGui.getWidget(parent);
                if (parentGui == null) continue;
                this.drawConnection(guiGraphics, parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.drawConnectivity(guiGraphics, scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(class_332 guiGraphics, BetterAdvancementWidget parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.method_740() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            float x1 = scrollX + this.x + 13 + 3;
            float y1 = scrollY + this.y + 13;
            float x2 = scrollX + parent.x + 13 + 3;
            float y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                float width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5f : 0.5f;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25f : 0.75f;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0f : 0.6666667f;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125f : 0.625f;
                        break;
                    }
                    default: {
                        float f = width = drawInside ? 3.0f : 1.0f;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(guiGraphics, x1 - 0.75f, y1 - 0.75f, x2 - 0.75f, y2 - 0.75f, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                float width;
                float f = width = drawInside ? 3.0f : 1.0f;
                if (drawInside) {
                    RenderUtil.drawRect(guiGraphics, x1 - 1.0f, y1 - 1.0f, x2 - 1.0f, y2 - 1.0f, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                guiGraphics.method_51738(endXHalf, startX, startY - 1, borderLineColor);
                guiGraphics.method_51738(endXHalf + 1, startX, startY, borderLineColor);
                guiGraphics.method_51738(endXHalf, startX, startY + 1, borderLineColor);
                guiGraphics.method_51738(endX, endXHalf - 1, endY - 1, borderLineColor);
                guiGraphics.method_51738(endX, endXHalf - 1, endY, borderLineColor);
                guiGraphics.method_51738(endX, endXHalf - 1, endY + 1, borderLineColor);
                guiGraphics.method_51742(endXHalf - 1, endY, startY, borderLineColor);
                guiGraphics.method_51742(endXHalf + 1, endY, startY, borderLineColor);
            } else {
                guiGraphics.method_51738(endXHalf, startX, startY, innerLineColor);
                guiGraphics.method_51738(endX, endXHalf, endY, innerLineColor);
                guiGraphics.method_51742(endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(class_332 guiGraphics, int scrollX, int scrollY) {
        if (!this.displayInfo.method_824() || this.advancementProgress != null && this.advancementProgress.method_740()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.method_735();
            class_455 advancementState = f >= 1.0f ? class_455.field_2701 : class_455.field_2699;
            guiGraphics.method_52707(class_10799.field_56883, advancementState.method_52754(this.displayInfo.method_815()), scrollX + this.x + 3, scrollY + this.y, 26, 26, this.betterDisplayInfo.getIconColor(advancementState));
            guiGraphics.method_55231(this.displayInfo.method_821(), scrollX + this.x + 8, scrollY + this.y + 5, this.betterDisplayInfo.defaultIconColor());
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.draw(guiGraphics, scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(class_167 advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(BetterAdvancementWidget betterAdvancementEntryScreen) {
        this.children.add(betterAdvancementEntryScreen);
    }

    public void drawHover(class_332 guiGraphics, int scrollX, int scrollY, float fade, int left, int top, float zoom) {
        int boxHeight;
        int rounded_scaled_scrolled_y;
        class_455 stateIcon;
        class_455 stateTitleRight;
        class_455 stateTitleLeft;
        boolean drawTop;
        int i;
        this.refreshHover();
        float scaled_scrolled_x = (float)(scrollX + this.x) * zoom;
        float scaled_scrolled_y = (float)(scrollY + this.y) * zoom;
        boolean drawLeft = (float)left + scaled_scrolled_x + (float)this.width + 26.0f >= (float)this.betterAdvancementTabGui.getScreen().internalWidth;
        String s = this.advancementProgress == null || this.advancementProgress.method_728() == null ? null : this.advancementProgress.method_728().getString();
        int n = i = s == null ? 0 : this.minecraft.field_1772.method_1727(s);
        if (!CriterionGrid.requiresShift || class_437.method_25442()) {
            if (this.criterionGrid.height < this.betterAdvancementTabGui.getScreen().field_22790) {
                float f = (float)top + scaled_scrolled_y;
                int n2 = this.description.size();
                Objects.requireNonNull(this.minecraft.field_1772);
                drawTop = f + (float)(n2 * 9) + (float)this.criterionGrid.height + 50.0f >= (float)this.betterAdvancementTabGui.getScreen().field_22790;
            } else {
                drawTop = false;
            }
        } else {
            float f = (float)top + scaled_scrolled_y;
            int n3 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            drawTop = f + (float)(n3 * 9) + 50.0f >= (float)this.betterAdvancementTabGui.getScreen().field_22790;
        }
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.method_735();
        int j = class_3532.method_15375((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2701;
            stateIcon = class_455.field_2701;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2699;
            stateTitleRight = class_455.field_2699;
            stateIcon = class_455.field_2699;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2701;
            stateIcon = class_455.field_2699;
        } else {
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2699;
            stateIcon = class_455.field_2699;
        }
        int k = this.width - j;
        int rounded_scaled_scrolled_x = Math.round(scaled_scrolled_x);
        int drawY = rounded_scaled_scrolled_y = Math.round(scaled_scrolled_y);
        int drawX = drawLeft ? rounded_scaled_scrolled_x - this.width + 26 + 6 : rounded_scaled_scrolled_x;
        if (!CriterionGrid.requiresShift || class_437.method_25442()) {
            int n4 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            boxHeight = 32 + n4 * 9 + this.criterionGrid.height;
        } else {
            int n5 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            boxHeight = 32 + n5 * 9;
        }
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(guiGraphics, drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(guiGraphics, drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        int left_side = Math.min(j, 240);
        guiGraphics.method_25291(class_10799.field_56883, Resources.Gui.WIDGETS, drawX, drawY, 0.0f, (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26), left_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        if (left_side < j) {
            guiGraphics.method_25291(class_10799.field_56883, Resources.Gui.WIDGETS, drawX + left_side, drawY, 16.0f, (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26), j - left_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        }
        int right_side = Math.min(k, 240);
        guiGraphics.method_25291(class_10799.field_56883, Resources.Gui.WIDGETS, drawX + j, drawY, (float)(256 - right_side), (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26), right_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleRight));
        if (right_side < k) {
            guiGraphics.method_25291(class_10799.field_56883, Resources.Gui.WIDGETS, drawX + j + right_side - 2, drawY, (float)(256 - k + right_side - 2), (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26), k - right_side + 2, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleRight));
        }
        guiGraphics.method_52707(class_10799.field_56883, stateIcon.method_52754(this.displayInfo.method_815()), rounded_scaled_scrolled_x + 3, rounded_scaled_scrolled_y, 26, 26, this.betterDisplayInfo.getIconColor(stateIcon));
        if (drawLeft) {
            guiGraphics.method_25303(this.minecraft.field_1772, this.title, drawX + 5, rounded_scaled_scrolled_y + 9, -1);
            if (s != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, s, rounded_scaled_scrolled_x - i, rounded_scaled_scrolled_y + 9, -1);
            }
        } else {
            guiGraphics.method_25303(this.minecraft.field_1772, this.title, rounded_scaled_scrolled_x + 32, rounded_scaled_scrolled_y + 9, -1);
            if (s != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, s, rounded_scaled_scrolled_x + this.width - i - 5, rounded_scaled_scrolled_y + 9, -1);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : rounded_scaled_scrolled_y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            class_327 class_3272 = this.minecraft.field_1772;
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_51430(class_3272, this.description.get(k1), drawX + 5, yOffset + k1 * 9, -5592406, false);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || class_437.method_25442()) {
            int xOffset = drawX + 5;
            int n6 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            yOffset += n6 * 9;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells().size(); ++rowIndex) {
                    class_327 class_3273 = this.minecraft.field_1772;
                    Objects.requireNonNull(this.minecraft.field_1772);
                    guiGraphics.method_51439(class_3273, col.cells().get(rowIndex), xOffset, yOffset + rowIndex * 9, -5592406, false);
                }
                xOffset += col.width();
            }
        }
        guiGraphics.method_51445(this.displayInfo.method_821(), rounded_scaled_scrolled_x + 8, rounded_scaled_scrolled_y + 5);
    }

    protected void render9Sprite(class_332 guiGraphics, int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WIDGETS, x, y, (float)textureX, (float)textureY, textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WIDGETS, x + width - textureHeight, y, (float)(textureX + textureWidth - textureHeight), (float)textureY, textureHeight, textureHeight, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WIDGETS, x, y + height - textureHeight, (float)textureX, (float)(textureY + textureDistance - textureHeight), textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WIDGETS, x + width - textureHeight, y + height - textureHeight, (float)(textureX + textureWidth - textureHeight), (float)(textureY + textureDistance - textureHeight), textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(double scrollX, double scrollY, double mouseX, double mouseY, float zoom) {
        if (!this.displayInfo.method_824() || this.advancementProgress != null && this.advancementProgress.method_740()) {
            double left = scrollX + (double)this.x;
            double right = left + 26.0;
            double top = scrollY + (double)this.y;
            double bottom = top + 26.0;
            return mouseX >= left * (double)zoom && mouseX <= right * (double)zoom && mouseY >= top * (double)zoom && mouseY <= bottom * (double)zoom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancementNode.method_53647().comp_1912().isPresent()) {
            this.parent = this.getFirstVisibleParent(this.advancementNode);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public class_8781 getAdvancement() {
        return this.advancementNode;
    }
}

