/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10201;
import net.minecraft.class_10394;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_836;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderUtil;

public abstract class ItemArmorGeoLayer<T extends class_1309, O, R extends class_10017>
extends GeoRenderLayer<T, O, R> {
    protected final class_10197 equipmentRenderer;
    protected final class_10201 equipmentAssets;
    protected final Function<class_2484.class_2485, class_5598> skullModels;

    public ItemArmorGeoLayer(GeoRenderer<T, O, R> geoRenderer, class_5617.class_5618 context) {
        super(geoRenderer);
        this.equipmentRenderer = context.method_64072();
        this.equipmentAssets = context.method_64071();
        this.skullModels = class_156.method_34866(type -> class_836.method_32160((class_5599)class_310.method_1551().method_31974(), (class_2484.class_2485)type));
    }

    protected abstract List<RenderData> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState) {
        EnumMap<class_1304, class_1799> equipment = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(class_1304.class));
        for (class_1304 slot : class_1304.values()) {
            equipment.put(slot, animatable.method_6118(slot));
        }
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        if (animatable instanceof class_1309) {
            T livingEntity = animatable;
            if (!((class_1799)equipment.get(class_1304.field_6174)).method_7960()) {
                float partialTick = ((GeoRenderState)renderState).getGeckolibData(DataTickets.PARTIAL_TICK).floatValue();
                ((GeoRenderState)renderState).addGeckolibData(DataTickets.ELYTRA_ROTATION, new class_243((double)((class_1309)livingEntity).field_52447.method_61404(partialTick), (double)((class_1309)livingEntity).field_52447.method_61405(partialTick), (double)((class_1309)livingEntity).field_52447.method_61406(partialTick)));
            }
        }
    }

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        class_1799 stack = this.getEquipmentStack(bone, renderData.slot, renderState);
        if (!stack.method_7960()) {
            consumer.accept(bone, (renderState2, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor) -> this.renderForBone(renderState2, renderData.slot, renderData.modelPartFactory, stack, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor));
        }
    }

    protected void renderForBone(R renderState, class_1304 slot, Function<class_572<?>, class_630> modelPartFactory, class_1799 equipmentStack, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, int packedLight, int packedOverlay, int renderColor) {
        class_1747 blockItem;
        if (equipmentStack.method_7960()) {
            return;
        }
        class_1792 class_17922 = equipmentStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            this.renderSkullAsArmor(poseStack, bone, equipmentStack, skullBlock, bufferSource, packedLight);
        } else {
            class_572<?> model = this.getHumanoidModelForRender(bone, slot, equipmentStack, renderState);
            class_630 modelPart = modelPartFactory.apply(model);
            if (!modelPart.field_3663.isEmpty()) {
                poseStack.method_22903();
                poseStack.method_22905(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepHumanoidModelForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.method_62100(poseStack, null, packedLight, packedOverlay, -1);
                } else {
                    class_10192 equippable = (class_10192)equipmentStack.method_58694(class_9334.field_54196);
                    if (equippable != null) {
                        equippable.comp_3176().ifPresent(assetId -> {
                            this.prepHumanoidModelForRender(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(poseStack, renderState, bone, slot, equipmentStack, equippable, (class_5321<class_10394>)assetId, model, modelPart, bufferSource, packedLight, packedOverlay);
                        });
                    }
                }
                poseStack.method_22909();
            }
        }
    }

    protected class_1799 getEquipmentStack(GeoBone bone, class_1304 slot, R renderState) {
        return ((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).getOrDefault(slot, class_1799.field_8037);
    }

    protected class_10186.class_10190 getEquipmentLayerType(R renderState, GeoBone bone, class_1304 slot, class_1799 armorStack, class_5321<class_10394> assetId) {
        if (slot == class_1304.field_6172) {
            return class_10186.class_10190.field_54126;
        }
        if (slot == class_1304.field_6174 && !this.equipmentAssets.method_64087(assetId).method_63996(class_10186.class_10190.field_54127).isEmpty()) {
            return class_10186.class_10190.field_54127;
        }
        return class_10186.class_10190.field_54125;
    }

    protected void renderVanillaArmorPiece(class_4587 poseStack, R renderState, GeoBone bone, class_1304 slot, class_1799 armorStack, class_10192 equippable, class_5321<class_10394> assetId, class_572<?> model, class_630 modelPart, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_10186.class_10190 layerType = this.getEquipmentLayerType(renderState, bone, slot, armorStack, assetId);
        class_3879 modelToRender = model;
        if (layerType == class_10186.class_10190.field_54127) {
            if (modelPart != model.field_3391) {
                return;
            }
            modelToRender = this.checkForElytraModel(layerType, renderState, bone, poseStack);
        } else {
            this.setVanillaModelPartVisibility(renderState, armorStack, bone, (class_572<?>)model, modelPart, slot);
        }
        this.equipmentRenderer.method_64077(layerType, assetId, modelToRender, armorStack, poseStack, bufferSource, packedLight);
    }

    protected class_3879 checkForElytraModel(class_10186.class_10190 layerType, R renderState, GeoBone bone, class_4587 poseStack) {
        class_563 model = GeckoLibClient.GENERIC_ELYTRA_MODEL.get();
        class_10034 humanoidRenderState = new class_10034();
        class_243 elytraRotation = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.ELYTRA_ROTATION, class_243.field_1353);
        humanoidRenderState.field_53410 = ((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_CROUCHING);
        humanoidRenderState.field_53415 = (float)elytraRotation.field_1352;
        humanoidRenderState.field_53416 = (float)elytraRotation.field_1351;
        humanoidRenderState.field_53417 = (float)elytraRotation.field_1350;
        model.method_17079(humanoidRenderState);
        poseStack.method_46416(0.0f, -1.5f, 0.125f);
        return model;
    }

    protected void setVanillaModelPartVisibility(R renderState, class_1799 armorStack, GeoBone bone, class_572<?> baseModel, class_630 modelPart, class_1304 slot) {
        baseModel.method_2805(false);
        modelPart.field_3665 = true;
    }

    @NotNull
    @ApiStatus.Internal
    protected <S extends class_10034> class_572<?> getHumanoidModelForRender(GeoBone bone, class_1304 slot, class_1799 stack, R renderState) {
        class_10034 humanoidRenderState1;
        class_10034 humanoidRenderState = renderState instanceof class_10034 ? (humanoidRenderState1 = (class_10034)renderState) : new class_10034();
        class_10186.class_10190 layerType = slot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125;
        class_572<class_10034> defaultModel = slot == class_1304.field_6172 ? GeckoLibClient.GENERIC_INNER_ARMOR_MODEL.get() : GeckoLibClient.GENERIC_OUTER_ARMOR_MODEL.get();
        return GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(humanoidRenderState, stack, slot, layerType, defaultModel);
    }

    protected void renderSkullAsArmor(class_4587 poseStack, GeoBone bone, class_1799 stack, class_2190 skullBlock, class_4597 bufferSource, int packedLight) {
        class_2484.class_2485 type = skullBlock.method_9327();
        class_5598 model = this.skullModels.apply(type);
        class_1921 renderType = class_836.method_65832((class_2484.class_2485)type, (class_9296)((class_9296)stack.method_58694(class_9334.field_49617)));
        poseStack.method_22903();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.method_22905(1.1875f, 1.1875f, 1.1875f);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)poseStack, (class_4597)bufferSource, (int)packedLight, (class_5598)model, (class_1921)renderType);
        poseStack.method_22909();
    }

    protected void prepHumanoidModelForRender(class_4587 poseStack, GeoBone bone, class_630 sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        class_630.class_628 armorCube = (class_630.class_628)sourcePart.field_3663.getFirst();
        double armorBoneSizeX = firstCube.size().method_10216();
        double armorBoneSizeY = firstCube.size().method_10214();
        double armorBoneSizeZ = firstCube.size().method_10215();
        double actualArmorSizeX = Math.abs(armorCube.field_3648 - armorCube.field_3645);
        double actualArmorSizeY = Math.abs(armorCube.field_3647 - armorCube.field_3644);
        double actualArmorSizeZ = Math.abs(armorCube.field_3646 - armorCube.field_3643);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.method_2851(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_3654 = -bone.getRotX();
        sourcePart.field_3675 = -bone.getRotY();
        sourcePart.field_3674 = bone.getRotZ();
        poseStack.method_22905(scaleX, scaleY, scaleZ);
    }

    public record RenderData(String boneName, class_1304 slot, Function<class_572<?>, class_630> modelPartFactory) {
        public static RenderData head(String boneName) {
            return new RenderData(boneName, class_1304.field_6169, model -> model.field_3398);
        }

        public static RenderData body(String boneName) {
            return new RenderData(boneName, class_1304.field_6174, model -> model.field_3391);
        }

        public static RenderData leftArm(String boneName) {
            return new RenderData(boneName, class_1304.field_6174, model -> model.field_27433);
        }

        public static RenderData rightArm(String boneName) {
            return new RenderData(boneName, class_1304.field_6174, model -> model.field_3401);
        }

        public static RenderData leftLeg(String boneName) {
            return new RenderData(boneName, class_1304.field_6172, model -> model.field_3397);
        }

        public static RenderData rightLeg(String boneName) {
            return new RenderData(boneName, class_1304.field_6172, model -> model.field_3392);
        }

        public static RenderData leftFoot(String boneName) {
            return new RenderData(boneName, class_1304.field_6166, model -> model.field_3397);
        }

        public static RenderData rightFoot(String boneName) {
            return new RenderData(boneName, class_1304.field_6166, model -> model.field_3392);
        }
    }
}

