/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.function.BiConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class CustomBoneTextureGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final String boneName;
    protected final class_2960 texture;

    public CustomBoneTextureGeoLayer(GeoRenderer<T, O, R> renderer, String boneName, class_2960 texture) {
        super(renderer);
        this.boneName = boneName;
        this.texture = texture;
    }

    @Override
    protected class_2960 getTextureResource(R renderState) {
        return this.texture;
    }

    protected class_1921 getRenderType(R renderState, class_2960 texture) {
        return this.renderer.getRenderType(renderState, texture);
    }

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        model.getBone(this.boneName).ifPresent(bone -> consumer.accept((GeoBone)bone, this::renderBone));
    }

    protected void renderBone(R renderState, class_4587 poseStack, GeoBone bone, @Nullable class_1921 renderType, class_4597 bufferSource, int packedLight, int packedOverlay, int renderColor) {
        if (renderType == null) {
            return;
        }
        class_2960 boneTexture = this.getTextureResource(renderState);
        class_2960 baseTexture = this.renderer.getTextureLocation(renderState);
        IntIntPair boneTextureSize = RenderUtil.getTextureDimensions(boneTexture);
        IntIntPair baseTextureSize = RenderUtil.getTextureDimensions(baseTexture);
        float widthRatio = (float)baseTextureSize.firstInt() / (float)boneTextureSize.firstInt();
        float heightRatio = (float)baseTextureSize.secondInt() / (float)boneTextureSize.secondInt();
        class_4588 buffer = bufferSource.getBuffer(this.getRenderType(renderState, boneTexture));
        bone.setHidden(false);
        bone.setChildrenHidden(true);
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(renderState, cube, poseStack, buffer, widthRatio, heightRatio, packedLight, packedOverlay, renderColor);
            poseStack.method_22909();
        }
        bone.setHidden(false);
    }

    @ApiStatus.Internal
    protected void renderCube(R renderState, GeoCube cube, class_4587 poseStack, class_4588 buffer, float widthRatio, float heightRatio, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(renderState, quad, poseState, normal, buffer, widthRatio, heightRatio, packedOverlay, packedLight, renderColor);
        }
    }

    @ApiStatus.Internal
    protected void createVerticesOfQuad(R renderState, GeoQuad quad, Matrix4f poseState, Vector3f normal, class_4588 buffer, float widthRatio, float heightRatio, int packedOverlay, int packedLight, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU() * widthRatio, vertex.texV() * heightRatio, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    @Override
    @ApiStatus.Internal
    public void preRender(R renderState, class_4587 poseStack, BakedGeoModel bakedModel, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        if (buffer == null) {
            return;
        }
        bakedModel.getBone(this.boneName).ifPresent(bone -> {
            bone.setHidden(true);
            bone.setChildrenHidden(false);
        });
    }
}

