/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant.dataticket;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;

public class DataTicket<D> {
    static final Map<Pair<Class<?>, String>, DataTicket<?>> IDENTITY_CACHE = new Object2ObjectOpenHashMap();
    private final String id;
    private final Class<? extends D> objectType;

    DataTicket(String id, Class<? extends D> objectType) {
        this.id = id;
        this.objectType = objectType;
    }

    public static <D> DataTicket<D> create(String id, Class<? extends D> objectType) {
        return IDENTITY_CACHE.computeIfAbsent(Pair.of(objectType, (Object)id), pair -> new DataTicket(id, objectType));
    }

    public String id() {
        return this.id;
    }

    public Class<? extends D> objectType() {
        return this.objectType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.objectType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataTicket)) {
            return false;
        }
        DataTicket other = (DataTicket)obj;
        return this.objectType == other.objectType && this.id.equals(other.id);
    }

    public String toString() {
        return "DataTicket{" + this.id + ": " + this.objectType.getName() + "}";
    }
}

