/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.values;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.config.api.values.ComplexConfigValue;
import org.quiltmc.config.api.values.CompoundConfigValue;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueMap;
import org.quiltmc.config.impl.tree.TrackedValueImpl;
import org.quiltmc.config.impl.values.ValueListImpl;

public final class ValueMapImpl<T>
implements ValueMap<T>,
CompoundConfigValue<T> {
    private final T defaultValue;
    private final Map<String, T> values;
    private TrackedValueImpl<?> configValue;

    public ValueMapImpl(T defaultValue, Map<String, T> values) {
        this.defaultValue = defaultValue;
        this.values = values;
    }

    @Override
    public void setValue(TrackedValue<?> configValue) {
        this.configValue = (TrackedValueImpl)configValue;
        if (this.defaultValue instanceof ComplexConfigValue) {
            for (T value : this.values.values()) {
                ((ComplexConfigValue)value).setValue(configValue);
            }
        }
    }

    @Override
    public ValueMap<T> copy() {
        LinkedHashMap<String, ComplexConfigValue> values = new LinkedHashMap<String, ComplexConfigValue>();
        for (Map.Entry<String, T> entry : this) {
            T value = entry.getValue();
            if (value instanceof CompoundConfigValue) {
                values.put(entry.getKey(), ((CompoundConfigValue)value).copy());
                continue;
            }
            values.put(entry.getKey(), (ComplexConfigValue)value);
        }
        ValueMapImpl<T> result = new ValueMapImpl<T>(this.defaultValue, values);
        result.setValue(this.configValue);
        return result;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.values.get(key);
    }

    @Override
    @Nullable
    public T put(String key, T value) {
        T v = this.values.put(key, value);
        if (value instanceof ComplexConfigValue) {
            ((ComplexConfigValue)value).setValue(this.configValue);
        }
        this.configValue.serializeAndInvokeCallbacks();
        return v;
    }

    @Override
    public T remove(Object key) {
        T result = this.values.remove(key);
        this.configValue.serializeAndInvokeCallbacks();
        return result;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends T> m) {
        this.values.putAll(m);
        for (T value : m.values()) {
            if (!(value instanceof ComplexConfigValue)) continue;
            ((ComplexConfigValue)value).setValue(this.configValue);
        }
        this.configValue.serializeAndInvokeCallbacks();
    }

    @Override
    public void clear() {
        this.values.clear();
        this.configValue.serializeAndInvokeCallbacks();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return this.values.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, T>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public Class<T> getType() {
        return this.defaultValue.getClass();
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void grow() {
        if (this.defaultValue instanceof ValueListImpl) {
            this.values.put("", ((ValueListImpl)this.defaultValue).copy());
        } else if (this.defaultValue instanceof ValueMapImpl) {
            this.values.put("", ((ValueMapImpl)this.defaultValue).copy());
        } else {
            this.values.put("", this.defaultValue);
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, T>> iterator() {
        return this.values.entrySet().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueMapImpl valueMap = (ValueMapImpl)o;
        return Objects.equals(this.defaultValue, valueMap.defaultValue) && Objects.equals(this.values, valueMap.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultValue, this.values, this.configValue);
    }
}

