/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.values;

import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.config.api.values.ValueKey;

public final class ValueKeyImpl
implements ValueKey {
    private final String string;
    private final String[] keys;

    public ValueKeyImpl(String[] keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("Keys cannot be empty");
        }
        this.keys = new String[keys.length];
        System.arraycopy(keys, 0, this.keys, 0, keys.length);
        StringBuilder builder = new StringBuilder(this.keys[0]);
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) {
                throw new IllegalArgumentException("No component of a key can be null");
            }
            if (i <= 0) continue;
            builder.append('.').append(this.keys[i]);
        }
        this.string = builder.toString();
    }

    public ValueKeyImpl(String key0, String ... keys) {
        this.keys = new String[keys.length + 1];
        this.keys[0] = key0;
        System.arraycopy(keys, 0, this.keys, 1, keys.length);
        StringBuilder builder = new StringBuilder(key0);
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) {
                throw new IllegalArgumentException("No component of a key can be null");
            }
            if (i <= 0) continue;
            builder.append('.').append(this.keys[i]);
        }
        this.string = builder.toString();
    }

    @Override
    public ValueKey child(String key) {
        String[] newKey = new String[this.keys.length + 1];
        System.arraycopy(this.keys, 0, newKey, 0, this.keys.length);
        newKey[newKey.length - 1] = key;
        return new ValueKeyImpl(newKey);
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValueKeyImpl)) {
            return false;
        }
        ValueKeyImpl other = (ValueKeyImpl)obj;
        if (other.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.getKeyComponent(i).equals(other.getKeyComponent(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.keys);
    }

    @Override
    public int length() {
        return this.keys.length;
    }

    @Override
    public String getKeyComponent(int i) {
        return this.keys[i];
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Itr();
    }

    @Override
    public boolean startsWith(ValueKey key) {
        for (int i = 0; i < key.length() && i < this.length(); ++i) {
            if (key.getKeyComponent(i).equals(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSibling(ValueKey key) {
        if (this.keys.length > 1 && this.keys.length == key.length()) {
            for (int i = 0; i < this.keys.length - 1; ++i) {
                if (this.keys[i].equals(key.getKeyComponent(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLastComponent() {
        return this.keys[this.keys.length - 1];
    }

    @Override
    public ValueKey child(ValueKey key) {
        String[] newKey = new String[this.keys.length + key.length()];
        System.arraycopy(this.keys, 0, newKey, 0, this.keys.length);
        System.arraycopy(((ValueKeyImpl)key).keys, 0, newKey, this.keys.length, key.length());
        return new ValueKeyImpl(newKey);
    }

    private final class Itr
    implements Iterator<String> {
        private int i = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.i < ValueKeyImpl.this.keys.length;
        }

        @Override
        public String next() {
            return ValueKeyImpl.this.keys[this.i++];
        }
    }
}

