/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.tree;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.config.api.metadata.MetadataType;
import org.quiltmc.config.api.values.ValueKey;
import org.quiltmc.config.api.values.ValueTreeNode;
import org.quiltmc.config.impl.AbstractMetadataContainer;
import org.quiltmc.config.impl.tree.Trie;

public final class SectionTreeNode
extends AbstractMetadataContainer
implements ValueTreeNode.Section {
    private final Trie.Node node;

    public SectionTreeNode(Trie.Node node, Map<MetadataType<?, ?>, Object> metadata) {
        super(metadata);
        this.node = node;
    }

    @Override
    public ValueKey key() {
        return this.node.getKey();
    }

    @Override
    public void propagateInheritedMetadata(Map<MetadataType<?, ?>, Object> inheritedMetadata) {
        for (Map.Entry<MetadataType<?, ?>, Object> entry : inheritedMetadata.entrySet()) {
            this.metadata.putIfAbsent(entry.getKey(), entry.getValue());
        }
        LinkedHashMap inheritorMetadata = new LinkedHashMap();
        for (Map.Entry entry : this.metadata.entrySet()) {
            if (!((MetadataType)entry.getKey()).isInherited()) continue;
            inheritorMetadata.put((MetadataType)entry.getKey(), entry.getValue());
        }
        for (ValueTreeNode node : this) {
            node.propagateInheritedMetadata(inheritorMetadata);
        }
    }

    @Override
    @NotNull
    public Iterator<ValueTreeNode> iterator() {
        return new Iterator<ValueTreeNode>(){
            private final Iterator<Trie.Node> itr;
            {
                this.itr = SectionTreeNode.this.node.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public ValueTreeNode next() {
                return this.itr.next().getValue();
            }
        };
    }
}

