/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.builders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.metadata.MetadataType;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.impl.tree.TrackedValueImpl;
import org.quiltmc.config.impl.values.ValueKeyImpl;

public class TrackedValueBuilderImpl<T>
implements TrackedValue.Builder<T> {
    private final T defaultValue;
    private final Set<String> key = new LinkedHashSet<String>();
    final Map<MetadataType<?, ?>, MetadataType.Builder<?>> metadata = new LinkedHashMap();
    private final List<TrackedValue.UpdateCallback<T>> callbacks = new ArrayList<TrackedValue.UpdateCallback<T>>();
    private final List<Constraint<T>> constraints = new ArrayList<Constraint<T>>();

    public TrackedValueBuilderImpl(T defaultValue, String key0) {
        Objects.requireNonNull(key0);
        this.defaultValue = defaultValue;
        this.key.add(key0);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public TrackedValue.Builder<T> key(String key) {
        this.key.add(key);
        return this;
    }

    @Override
    public <M, B extends MetadataType.Builder<M>> TrackedValue.Builder<T> metadata(MetadataType<M, B> type, Consumer<B> builderConsumer) {
        builderConsumer.accept(this.metadata.computeIfAbsent(type, t -> type.newBuilder()));
        return this;
    }

    @Override
    public TrackedValue.Builder<T> constraint(Constraint<T> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public TrackedValue.Builder<T> callback(TrackedValue.UpdateCallback<T> callback) {
        this.callbacks.add(callback);
        return this;
    }

    public TrackedValue<T> build() {
        LinkedHashMap metadata = new LinkedHashMap();
        for (Map.Entry<MetadataType<?, ?>, MetadataType.Builder<?>> entry : this.metadata.entrySet()) {
            metadata.put(entry.getKey(), entry.getValue().build());
        }
        return new TrackedValueImpl<T>(new ValueKeyImpl(this.key.toArray(new String[0])), this.defaultValue, metadata, this.callbacks, this.constraints);
    }
}

