/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.api.metadata;

import java.security.InvalidParameterException;
import java.util.Objects;

public class DisplayName {
    private final String name;
    private final boolean translatable;

    public DisplayName(String name, boolean translatable) {
        if (name == null || name.isEmpty()) {
            throw new InvalidParameterException("Cannot set serialized name to an empty value!");
        }
        this.translatable = translatable;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayName that = (DisplayName)o;
        return this.translatable == that.translatable && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.translatable);
    }
}

