/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3962;
import org.jetbrains.annotations.Nullable;

public class ComposterWrapper
extends SnapshotParticipant<Float> {
    private static final Map<WorldLocation, ComposterWrapper> COMPOSTERS = new MapMaker().concurrencyLevel(1).weakValues().makeMap();
    private static final float DO_NOTHING = 0.0f;
    private static final float EXTRACT_BONEMEAL = -1.0f;
    private final WorldLocation location;
    private Float increaseProbability = Float.valueOf(0.0f);
    private final TopStorage upStorage = new TopStorage();
    private final BottomStorage downStorage = new BottomStorage();

    @Nullable
    public static Storage<ItemVariant> get(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        if (direction != null && direction.method_10166().method_10178()) {
            WorldLocation location = new WorldLocation(world, pos.method_10062());
            ComposterWrapper composterWrapper = COMPOSTERS.computeIfAbsent(location, ComposterWrapper::new);
            return direction == class_2350.field_11036 ? composterWrapper.upStorage : composterWrapper.downStorage;
        }
        return null;
    }

    private ComposterWrapper(WorldLocation location) {
        this.location = location;
    }

    @Override
    protected Float createSnapshot() {
        return this.increaseProbability;
    }

    @Override
    protected void readSnapshot(Float snapshot) {
        this.increaseProbability = snapshot;
    }

    @Override
    protected void onFinalCommit() {
        if (this.increaseProbability.floatValue() == -1.0f) {
            this.location.setBlockState((class_2680)this.location.getBlockState().method_11657((class_2769)class_3962.field_17565, (Comparable)Integer.valueOf(0)));
            this.location.world.method_8396(null, this.location.pos, class_3417.field_17606, class_3419.field_15245, 1.0f, 1.0f);
        } else if (this.increaseProbability.floatValue() > 0.0f) {
            boolean increaseSuccessful;
            class_2680 state = this.location.getBlockState();
            boolean bl = increaseSuccessful = (Integer)state.method_11654((class_2769)class_3962.field_17565) == 0 || this.location.world.method_8409().method_43058() < (double)this.increaseProbability.floatValue();
            if (increaseSuccessful) {
                int newLevel = (Integer)state.method_11654((class_2769)class_3962.field_17565) + 1;
                class_2680 newState = (class_2680)state.method_11657((class_2769)class_3962.field_17565, (Comparable)Integer.valueOf(newLevel));
                this.location.setBlockState(newState);
                if (newLevel == 7) {
                    this.location.world.method_64310(this.location.pos, state.method_26204(), 20);
                }
            }
            this.location.world.method_20290(1500, this.location.pos, increaseSuccessful ? 1 : 0);
        }
        this.increaseProbability = Float.valueOf(0.0f);
    }

    private record WorldLocation(class_1937 world, class_2338 pos) {
        private class_2680 getBlockState() {
            return this.world.method_8320(this.pos);
        }

        private void setBlockState(class_2680 state) {
            this.world.method_8501(this.pos, state);
        }

        @Override
        public String toString() {
            return DebugMessages.forGlobalPos(this.world, this.pos);
        }
    }

    private class TopStorage
    implements InsertionOnlyStorage<ItemVariant> {
        private TopStorage() {
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            if (ComposterWrapper.this.increaseProbability.floatValue() != 0.0f) {
                return 0L;
            }
            if ((Integer)ComposterWrapper.this.location.getBlockState().method_11654((class_2769)class_3962.field_17565) >= 7) {
                return 0L;
            }
            float insertedIncreaseProbability = class_3962.field_17566.getFloat((Object)resource.getItem());
            if (insertedIncreaseProbability <= 0.0f) {
                return 0L;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = Float.valueOf(insertedIncreaseProbability);
            return 1L;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/top]";
        }
    }

    private class BottomStorage
    implements ExtractionOnlyStorage<ItemVariant>,
    SingleSlotStorage<ItemVariant> {
        private static final ItemVariant BONE_MEAL = ItemVariant.of((class_1935)class_1802.field_8324);

        private BottomStorage() {
        }

        private boolean hasBoneMeal() {
            return ComposterWrapper.this.increaseProbability.floatValue() == 0.0f && (Integer)ComposterWrapper.this.location.getBlockState().method_11654((class_2769)class_3962.field_17565) == 8;
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            if (!BONE_MEAL.equals(resource)) {
                return 0L;
            }
            if (!this.hasBoneMeal()) {
                return 0L;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = Float.valueOf(-1.0f);
            return 1L;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        @Override
        public ItemVariant getResource() {
            return BONE_MEAL;
        }

        @Override
        public long getAmount() {
            return this.hasBoneMeal() ? 1L : 0L;
        }

        @Override
        public long getCapacity() {
            return 1L;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/bottom]";
        }
    }
}

