/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.buffer.ByteBufUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class PayloadTypeRegistryImpl<B extends class_2540>
implements PayloadTypeRegistry<B> {
    public static final PayloadTypeRegistryImpl<class_2540> CONFIGURATION_C2S = new PayloadTypeRegistryImpl(class_2539.field_45671, class_2598.field_11941);
    public static final PayloadTypeRegistryImpl<class_2540> CONFIGURATION_S2C = new PayloadTypeRegistryImpl(class_2539.field_45671, class_2598.field_11942);
    public static final PayloadTypeRegistryImpl<class_9129> PLAY_C2S = new PayloadTypeRegistryImpl(class_2539.field_20591, class_2598.field_11941);
    public static final PayloadTypeRegistryImpl<class_9129> PLAY_S2C = new PayloadTypeRegistryImpl(class_2539.field_20591, class_2598.field_11942);
    private final Map<class_2960, class_8710.class_9155<B, ? extends class_8710>> packetTypes = new HashMap<class_2960, class_8710.class_9155<B, ? extends class_8710>>();
    private final Object2IntMap<class_2960> maxPacketSize = new Object2IntOpenHashMap();
    private final class_2539 state;
    private final class_2598 side;
    private final int minimalSplittableSize;

    private PayloadTypeRegistryImpl(class_2539 state, class_2598 side) {
        this.state = state;
        this.side = side;
        this.minimalSplittableSize = side == class_2598.field_11942 ? 0x100000 : Short.MAX_VALUE;
    }

    @Nullable
    public static PayloadTypeRegistryImpl<?> get(class_9127<?> state) {
        return switch (state.comp_2234()) {
            case class_2539.field_45671 -> {
                if (state.comp_2235() == class_2598.field_11942) {
                    yield CONFIGURATION_S2C;
                }
                yield CONFIGURATION_C2S;
            }
            case class_2539.field_20591 -> {
                if (state.comp_2235() == class_2598.field_11942) {
                    yield PLAY_S2C;
                }
                yield PLAY_C2S;
            }
            default -> null;
        };
    }

    @Override
    public <T extends class_8710> class_8710.class_9155<? super B, T> register(class_8710.class_9154<T> id, class_9139<? super B, T> codec) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(codec, "codec");
        class_8710.class_9155 payloadType = new class_8710.class_9155(id, codec.method_56430());
        if (this.packetTypes.containsKey(id.comp_2242())) {
            throw new IllegalArgumentException("Packet type " + String.valueOf(id) + " is already registered!");
        }
        this.packetTypes.put(id.comp_2242(), payloadType);
        return payloadType;
    }

    @Override
    public <T extends class_8710> class_8710.class_9155<? super B, T> registerLarge(class_8710.class_9154<T> id, class_9139<? super B, T> codec, int maxPayloadSize) {
        if (maxPayloadSize < 0) {
            throw new IllegalArgumentException("Provided maxPayloadSize needs to be positive!");
        }
        class_8710.class_9155<? super B, T> type = this.register(id, codec);
        int identifierSize = ByteBufUtil.utf8MaxBytes((CharSequence)id.comp_2242().toString());
        int maxPacketSize = maxPayloadSize + class_8703.method_53015((int)identifierSize) + identifierSize + 10;
        if (maxPacketSize < 0) {
            maxPacketSize = Integer.MAX_VALUE;
        }
        if (maxPacketSize > this.minimalSplittableSize) {
            this.maxPacketSize.put((Object)id.comp_2242(), maxPacketSize);
        }
        return type;
    }

    @Nullable
    public class_8710.class_9155<B, ? extends class_8710> get(class_2960 id) {
        return this.packetTypes.get(id);
    }

    @Nullable
    public <T extends class_8710> class_8710.class_9155<B, T> get(class_8710.class_9154<T> id) {
        return this.packetTypes.get(id.comp_2242());
    }

    public int getMaxPacketSize(class_2960 id) {
        return this.maxPacketSize.getOrDefault((Object)id, -1);
    }

    public class_2539 getPhase() {
        return this.state;
    }

    public class_2598 getSide() {
        return this.side;
    }
}

