/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.builder.SoundTypeBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.include.com.google.common.base.Preconditions;

@Environment(value=EnvType.CLIENT)
public final class SoundTypeBuilderImpl
implements SoundTypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundTypeBuilderImpl.class);
    private class_3419 category = class_3419.field_15254;
    @Nullable
    private String subtitle;
    private final List<Entry> sounds = new ArrayList<Entry>();

    @Override
    public SoundTypeBuilder category(class_3419 category) {
        Objects.requireNonNull(category, "Sound event category must not be null.");
        this.category = category;
        return this;
    }

    @Override
    public SoundTypeBuilder subtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @Override
    public SoundTypeBuilder sound(SoundTypeBuilder.EntryBuilder sound) {
        Objects.requireNonNull(sound, "Sound must not be null.");
        this.sounds.add(((EntryBuilderImpl)sound).build(""));
        return this;
    }

    @Override
    public SoundTypeBuilder sound(SoundTypeBuilder.EntryBuilder sound, int count) {
        Objects.requireNonNull(sound, "Sound must not be null.");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than zero.");
        for (int i = 1; i <= count; ++i) {
            this.sounds.add(((EntryBuilderImpl)sound).build(Integer.toString(i)));
        }
        return this;
    }

    public SoundType build() {
        Preconditions.checkState((!this.sounds.isEmpty() ? 1 : 0) != 0, (Object)"Sound definition must have at least one sound file");
        for (Entry sound : this.sounds) {
            if (sound.type() != SoundTypeBuilder.RegistrationType.SOUND_EVENT) continue;
            class_7923.field_41172.method_17966(sound.name()).orElseThrow(() -> new IllegalStateException("Referenced sound event " + String.valueOf(sound.name()) + " does not exist"));
        }
        return new SoundType(this.sounds, this.category, Optional.ofNullable(this.subtitle));
    }

    @Environment(value=EnvType.CLIENT)
    public static final class EntryBuilderImpl
    implements SoundTypeBuilder.EntryBuilder {
        private final class_2960 id;
        private final SoundTypeBuilder.RegistrationType type;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int attenuationDistance = 16;
        private int weight = 1;
        private boolean stream = false;
        private boolean preload = false;

        private EntryBuilderImpl(SoundTypeBuilder.RegistrationType type, class_2960 id) {
            this.type = type;
            this.id = id;
        }

        public static SoundTypeBuilder.EntryBuilder create(SoundTypeBuilder.RegistrationType type, class_2960 id) {
            return new EntryBuilderImpl(type, id);
        }

        public static SoundTypeBuilder.EntryBuilder ofFile(class_2960 soundFile) {
            Objects.requireNonNull(soundFile, "Sound file/event id must not be null.");
            if (soundFile.method_12832().indexOf(46) != -1) {
                LOGGER.warn("Sound file \"" + String.valueOf(soundFile) + "\" should not have a file extension and may result in the sound event not playing.");
            }
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.FILE, soundFile);
        }

        public static SoundTypeBuilder.EntryBuilder ofEvent(class_3414 event) {
            Objects.requireNonNull(event, "Sound event must not be null.");
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.SOUND_EVENT, event.comp_3319());
        }

        public static SoundTypeBuilder.EntryBuilder ofEvent(class_6880<class_3414> event) {
            Objects.requireNonNull(event, "Sound event key must not be null.");
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.SOUND_EVENT, ((class_5321)event.method_40230().orElseThrow(() -> new IllegalArgumentException("Direct (non-registered) sound event cannot be added"))).method_29177());
        }

        @Override
        public SoundTypeBuilder.EntryBuilder volume(float volume) {
            Preconditions.checkArgument((volume > 0.0f && volume <= 1.0f ? 1 : 0) != 0, (Object)"Sound volume must be greater than 0 and less than or equal to 1.");
            this.volume = volume;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder pitch(float pitch) {
            Preconditions.checkArgument((pitch >= 0.5f && pitch <= 2.0f ? 1 : 0) != 0, (Object)"Sound pitch must be between 0.5 and 2 (inclusive)");
            this.pitch = pitch;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder attenuationDistance(int attenuationDistance) {
            this.attenuationDistance = attenuationDistance;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder weight(int weight) {
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Sound must have a weight of at least 1.");
            this.weight = weight;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder preload(boolean preload) {
            this.preload = preload;
            return this;
        }

        public Entry build(@Nullable String suffix) {
            return new Entry(this.id.method_48331(suffix == null ? "" : suffix), this.type, this.volume, this.pitch, this.weight, this.attenuationDistance, this.stream, this.preload);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Entry(class_2960 name, SoundTypeBuilder.RegistrationType type, float volume, float pitch, int weight, int attenuationDistance, boolean stream, boolean preload) {
        private static final Codec<Entry> MAP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("name").forGetter(Entry::name), (App)SoundTypeBuilder.RegistrationType.CODEC.optionalFieldOf("type", (Object)SoundTypeBuilder.RegistrationType.FILE).forGetter(Entry::type), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Entry::volume), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Entry::pitch), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight), (App)Codec.INT.optionalFieldOf("attenuation_distance", (Object)16).forGetter(Entry::attenuationDistance), (App)Codec.BOOL.optionalFieldOf("stream", (Object)false).forGetter(Entry::stream), (App)Codec.BOOL.optionalFieldOf("preload", (Object)false).forGetter(Entry::preload)).apply((Applicative)instance, Entry::new));
        private static final Codec<Entry> STRING_CODEC = class_2960.field_25139.xmap(id -> new Entry((class_2960)id, SoundTypeBuilder.RegistrationType.FILE, 1.0f, 1.0f, 1, 16, false, false), Entry::name);
        private static final Codec<Entry> CODEC = Codec.xor(STRING_CODEC, MAP_CODEC).xmap(Either::unwrap, sound -> {
            if (sound.type() != SoundTypeBuilder.RegistrationType.FILE || sound.volume() != 1.0f || sound.pitch() != 1.0f || sound.weight() != 1 || sound.attenuationDistance() != 16 || sound.stream() || sound.preload()) {
                return Either.right((Object)sound);
            }
            return Either.left((Object)sound);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public record SoundType(List<Entry> sounds, class_3419 category, Optional<String> subtitle) {
        private static final Map<String, class_3419> CATEGORIES = Arrays.stream(class_3419.values()).collect(Collectors.toMap(class_3419::method_14840, Function.identity()));
        private static final Codec<class_3419> SOUND_CATEGORY_CODEC = Codec.stringResolver(class_3419::method_14840, name -> CATEGORIES.getOrDefault(name.toLowerCase(Locale.ROOT), class_3419.field_15254));
        public static final Codec<SoundType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("sounds").forGetter(SoundType::sounds), (App)SOUND_CATEGORY_CODEC.fieldOf("category").forGetter(SoundType::category), (App)Codec.STRING.optionalFieldOf("subtitle").forGetter(SoundType::subtitle)).apply((Applicative)instance, SoundType::new));
    }
}

