/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.quiltmc.config.api.Config;
import org.quiltmc.config.api.annotations.Alias;
import org.quiltmc.config.api.annotations.SerializedName;
import org.quiltmc.config.api.annotations.SerializedNameConvention;
import org.quiltmc.config.api.values.CompoundConfigValue;
import org.quiltmc.config.api.values.ValueKey;
import org.quiltmc.config.api.values.ValueTreeNode;
import org.quiltmc.config.impl.values.ValueKeyImpl;

public class SerializerUtils {
    public static Optional<String> getDefaultValueString(Object defaultValue) {
        try {
            if (defaultValue.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class && !(defaultValue instanceof CompoundConfigValue)) {
                return Optional.of(defaultValue.toString());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<String> createEnumOptionsComment(Object defaultValue) {
        if (defaultValue.getClass().isEnum()) {
            StringBuilder options = new StringBuilder("options: ");
            ?[] enumConstants = defaultValue.getClass().getEnumConstants();
            int enumConstantsLength = enumConstants.length;
            for (int i = 0; i < enumConstantsLength; ++i) {
                Object o = enumConstants[i];
                options.append(o);
                if (i >= enumConstantsLength - 1) continue;
                options.append(", ");
            }
            return Optional.of(options.toString());
        }
        return Optional.empty();
    }

    public static List<ValueKey> getPossibleKeys(Config config, ValueTreeNode value) {
        ArrayList<ValueKey> possibleKeys = new ArrayList<ValueKey>();
        possibleKeys.add(SerializerUtils.getSerializedKey(config, value));
        if (value.hasMetadata(Alias.TYPE)) {
            for (String alias : value.metadata(Alias.TYPE)) {
                ArrayList<String> aliasKey = new ArrayList<String>();
                for (int i = 0; i < value.key().length(); ++i) {
                    if (i != value.key().length() - 1) {
                        aliasKey.add(value.key().getKeyComponent(i));
                        continue;
                    }
                    aliasKey.add(alias);
                }
                possibleKeys.add(new ValueKeyImpl(aliasKey.toArray(new String[0])));
            }
        }
        return possibleKeys;
    }

    public static ValueKey getSerializedKey(Config config, ValueTreeNode value) {
        ArrayList<String> serializedKey = new ArrayList<String>();
        ValueKey key = value.key();
        ArrayList<String> rawKey = new ArrayList<String>();
        for (int i = 0; i < value.key().length(); ++i) {
            rawKey.add(key.getKeyComponent(i));
            ValueTreeNode currentNode = config.getNode(rawKey);
            serializedKey.add(SerializerUtils.getSerializedName(currentNode));
        }
        return new ValueKeyImpl(serializedKey.toArray(new String[0]));
    }

    public static String getSerializedName(ValueTreeNode value) {
        if (value.hasMetadata(SerializedName.TYPE)) {
            return value.metadata(SerializedName.TYPE).getName();
        }
        if (value.hasMetadata(SerializedNameConvention.TYPE)) {
            return value.metadata(SerializedNameConvention.TYPE).coerce(value.key().getLastComponent());
        }
        return value.key().getLastComponent();
    }
}

