/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.impl.tree;

import java.util.ArrayDeque;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueKey;
import org.quiltmc.config.api.values.ValueTreeNode;
import org.quiltmc.config.impl.builders.SectionBuilderImpl;
import org.quiltmc.config.impl.tree.SectionTreeNode;
import org.quiltmc.config.impl.values.ValueKeyImpl;

public final class Trie {
    private final Node root = new Node(null, null, null);
    private int modCount;

    public Iterable<ValueTreeNode> leaves() {
        return () -> new LeafItr();
    }

    public Iterable<ValueTreeNode> nodes() {
        return new Iterable<ValueTreeNode>(){

            @Override
            @NotNull
            public Iterator<ValueTreeNode> iterator() {
                return new Iterator<ValueTreeNode>(){
                    private final Iterator<Node> itr;
                    {
                        this.itr = Trie.this.root.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itr.hasNext();
                    }

                    @Override
                    public ValueTreeNode next() {
                        return this.itr.next().getValue();
                    }
                };
            }
        };
    }

    public ValueTreeNode put(Iterable<String> key, ValueTreeNode value) {
        int modifiedCount = this.modCount;
        Node node = this.root;
        for (String keyComponent : key) {
            if (node.value == null) {
                node.setValue(new SectionTreeNode(node, new LinkedHashMap(0)));
            }
            node = node.getOrCreateChild(keyComponent);
        }
        node.setValue(value);
        if (modifiedCount == this.modCount) {
            ++this.modCount;
        }
        return null;
    }

    public void put(Iterable<String> key, SectionBuilderImpl sectionBuilder) {
        int modifiedCount = this.modCount;
        Node node = this.root;
        for (String keyComponent : key) {
            node = node.getOrCreateChild(keyComponent);
        }
        sectionBuilder.build(node);
        if (modifiedCount == this.modCount) {
            ++this.modCount;
        }
    }

    public TrackedValue<?> get(Iterable<String> key) {
        return (TrackedValue)this.getNode(key);
    }

    public ValueTreeNode getNode(Iterable<String> key) {
        Node node = this.root;
        for (String k : key) {
            node = node.getOrCreateChild(k);
        }
        return node.getValue();
    }

    public class Node
    implements Iterable<Node> {
        private final Node parent;
        private final ValueKey key;
        private final Map<String, Node> children = new LinkedHashMap<String, Node>();
        private ValueTreeNode value;

        private Node(Node parent, ValueKey key, ValueTreeNode value) {
            this.parent = parent;
            this.key = key;
            this.value = value;
        }

        private Node(Node parent, ValueKey key) {
            this(parent, key, null);
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public ValueKey getKey() {
            return this.key;
        }

        public Node getParent() {
            return this.parent;
        }

        private Node getOrCreateChild(String key) {
            if (this.children.containsKey(key)) {
                return this.children.get(key);
            }
            ++Trie.this.modCount;
            Node child = new Node(this, this.key == null ? new ValueKeyImpl(key, new String[0]) : this.key.child(key));
            this.children.put(key, child);
            return child;
        }

        public ValueTreeNode getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public Iterator<Node> iterator() {
            return this.children.values().iterator();
        }

        public void setValue(ValueTreeNode value) {
            if (this.value != null && !(value instanceof SectionTreeNode)) {
                throw new UnsupportedOperationException("Cannot put node '" + value.key() + "': Node already exists");
            }
            this.value = value;
        }
    }

    private class LeafItr
    implements Iterator<ValueTreeNode> {
        private final int modCount;
        private final Deque<Iterator<Node>> iterators;

        private LeafItr() {
            this.modCount = Trie.this.modCount;
            this.iterators = new ArrayDeque<Iterator<Node>>();
            this.iterators.addFirst(Trie.this.root.children.values().iterator());
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            while (!this.iterators.isEmpty() && !this.iterators.peek().hasNext()) {
                this.iterators.pop();
            }
            return !this.iterators.isEmpty();
        }

        @Override
        public ValueTreeNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.checkForComodification();
            Iterator<Node> itr = this.iterators.removeFirst();
            Node n = itr.next();
            if (itr.hasNext()) {
                this.iterators.addFirst(itr);
            }
            while (n.hasChildren()) {
                itr = n.children.values().iterator();
                n = itr.next();
                this.iterators.addFirst(itr);
            }
            this.checkForComodification();
            return n.getValue();
        }

        private void checkForComodification() {
            if (this.modCount != Trie.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

