/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.config.api;

import java.util.List;
import java.util.function.BiFunction;
import org.quiltmc.config.api.exceptions.ConfigParseException;
import org.quiltmc.config.api.values.ConfigSerializableObject;
import org.quiltmc.config.api.values.ValueList;
import org.quiltmc.config.api.values.ValueMap;

public final class MarshallingUtils {
    private MarshallingUtils() {
    }

    private static <M, L> Object coerce(Object object, Object to, BiFunction<M, ValueMap<?>, ValueMap<?>> valueMapCreator, BiFunction<L, ValueList<?>, ValueList<?>> valueListCreator) {
        if (to instanceof Integer) {
            return ((Number)object).intValue();
        }
        if (to instanceof Long) {
            return ((Number)object).longValue();
        }
        if (to instanceof Float) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (to instanceof Double) {
            return ((Number)object).doubleValue();
        }
        if (to instanceof String) {
            return object;
        }
        if (to instanceof Boolean) {
            return object;
        }
        if (to instanceof ConfigSerializableObject) {
            return ((ConfigSerializableObject)to).convertFrom(MarshallingUtils.coerce(object, ((ConfigSerializableObject)to).getRepresentation(), valueMapCreator, valueListCreator));
        }
        if (to instanceof ValueMap) {
            return valueMapCreator.apply(object, (ValueMap)to);
        }
        if (to instanceof ValueList) {
            return valueListCreator.apply(object, (ValueList)to);
        }
        if (to.getClass().isEnum()) {
            for (Object o : to.getClass().getEnumConstants()) {
                if (!((Enum)o).name().equalsIgnoreCase((String)object)) continue;
                return o;
            }
            throw new ConfigParseException("Unexpected value '" + object + "' for enum class '" + to.getClass() + "'");
        }
        throw new ConfigParseException("Unexpected value type: " + to.getClass());
    }

    public static <M, L> Object coerce(Object object, Object to, ValueMapCreator<M> creator) {
        MapCoercer mapCoercer = new MapCoercer(creator);
        return MarshallingUtils.coerce(object, to, mapCoercer, new ListCoercer(mapCoercer));
    }

    private static final class MapCoercer<M>
    implements BiFunction<M, ValueMap<?>, ValueMap<?>> {
        private final ValueMapCreator<M> creator;

        private MapCoercer(ValueMapCreator<M> creator) {
            this.creator = creator;
        }

        @Override
        public ValueMap<?> apply(M object, ValueMap<?> defaultValue) {
            ValueMap.Builder builder = ValueMap.builder(defaultValue.getDefaultValue());
            this.creator.create(object, (key, value) -> builder.put(key, MarshallingUtils.coerce(value, defaultValue.getDefaultValue(), this.creator)));
            return builder.build();
        }
    }

    public static interface ValueMapCreator<M> {
        public void create(M var1, MapEntryConsumer var2);
    }

    private static final class ListCoercer<M>
    implements BiFunction<List<?>, ValueList<?>, ValueList<?>> {
        private final BiFunction<M, ValueMap<?>, ValueMap<?>> valueMapCreator;

        private ListCoercer(BiFunction<M, ValueMap<?>, ValueMap<?>> valueMapCreator) {
            this.valueMapCreator = valueMapCreator;
        }

        @Override
        public ValueList<?> apply(List<?> list, ValueList<?> defaultValue) {
            Object[] values = list.toArray();
            for (int i = 0; i < values.length; ++i) {
                values[i] = MarshallingUtils.coerce(values[i], defaultValue.getDefaultValue(), this.valueMapCreator, this);
            }
            return ValueList.create(defaultValue.getDefaultValue(), values);
        }
    }

    public static interface MapEntryConsumer {
        public void put(String var1, Object var2);
    }
}

